import { api, APIError } from "encore.dev/api";
import { db } from "./db";

interface UpdateMadrasahRequest {
  id: string;
  nsm?: string;
  npsn?: string;
  nama_madrasah?: string;
  alamat?: string;
  kecamatan?: string;
  kabupaten?: string;
  provinsi?: string;
  akreditasi?: string;
  status?: string;
  nama_kepala?: string;
}

interface Madrasah {
  id: string;
  nsm: string;
  npsn: string;
  nama_madrasah: string;
  alamat: string;
  kecamatan: string;
  kabupaten: string;
  provinsi: string;
  akreditasi: string;
  status: string;
  nama_kepala: string;
}

// Updates an existing madrasah (superadmin only)
export const updateMadrasah = api<UpdateMadrasahRequest, Madrasah>(
  { expose: true, method: "PUT", path: "/madrasah/:id" },
  async (req) => {
    const { id, ...updateData } = req;
    
    // Check if madrasah exists
    const existing = await db.queryRow<{ id: string }>`
      SELECT id FROM madrasah WHERE id = ${id}
    `;
    
    if (!existing) {
      throw APIError.notFound("Madrasah not found");
    }
    
    // Build update query dynamically
    const updateFields: string[] = [];
    const updateValues: any[] = [];
    let paramIndex = 1;
    
    Object.entries(updateData).forEach(([key, value]) => {
      if (value !== undefined) {
        updateFields.push(`${key} = $${paramIndex}`);
        updateValues.push(value);
        paramIndex++;
      }
    });
    
    if (updateFields.length === 0) {
      throw APIError.invalidArgument("No fields to update");
    }
    
    const madrasah = await db.rawQueryRow<Madrasah>(
      `UPDATE madrasah 
       SET ${updateFields.join(', ')}, updated_at = CURRENT_TIMESTAMP
       WHERE id = $${paramIndex}
       RETURNING id, nsm, npsn, nama_madrasah, alamat, kecamatan, kabupaten, provinsi, akreditasi, status, nama_kepala`,
      ...updateValues, id
    );
    
    return madrasah!;
  }
);
