import { api } from "encore.dev/api";
import { SQLDatabase } from "encore.dev/storage/sqldb";

const db = SQLDatabase.named("madrasah");

export interface CreateSiswaRequest {
  madrasah_id: string;
  nisn?: string;
  nis?: string;
  nama_lengkap: string;
  tempat_lahir?: string;
  tanggal_lahir?: string;
  jenis_kelamin?: string;
  agama?: string;
  alamat?: string;
  no_telepon?: string;
  nama_ayah?: string;
  nama_ibu?: string;
  pekerjaan_ayah?: string;
  pekerjaan_ibu?: string;
  kelas?: string;
  tahun_masuk?: number;
  status?: string;
}

export interface Siswa {
  id: string;
  madrasah_id: string;
  nisn: string;
  nis: string;
  nama_lengkap: string;
  tempat_lahir: string;
  tanggal_lahir: string;
  jenis_kelamin: string;
  agama: string;
  alamat: string;
  no_telepon: string;
  nama_ayah: string;
  nama_ibu: string;
  pekerjaan_ayah: string;
  pekerjaan_ibu: string;
  kelas: string;
  tahun_masuk: number;
  status: string;
}

// Creates a new siswa
export const createSiswa = api<CreateSiswaRequest, Siswa>(
  { expose: true, method: "POST", path: "/siswa" },
  async (req) => {
    const siswa = await db.queryRow<Siswa>`
      INSERT INTO siswa (madrasah_id, nisn, nis, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                        no_telepon, nama_ayah, nama_ibu, pekerjaan_ayah, pekerjaan_ibu, kelas, tahun_masuk, status)
      VALUES (${req.madrasah_id}, ${req.nisn || ""}, ${req.nis || ""}, ${req.nama_lengkap}, ${req.tempat_lahir || ""}, 
              ${req.tanggal_lahir || null}, ${req.jenis_kelamin || ""}, ${req.agama || ""}, ${req.alamat || ""}, 
              ${req.no_telepon || ""}, ${req.nama_ayah || ""}, ${req.nama_ibu || ""}, ${req.pekerjaan_ayah || ""}, 
              ${req.pekerjaan_ibu || ""}, ${req.kelas || ""}, ${req.tahun_masuk || null}, ${req.status || "aktif"})
      RETURNING id, madrasah_id, nisn, nis, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                no_telepon, nama_ayah, nama_ibu, pekerjaan_ayah, pekerjaan_ibu, kelas, tahun_masuk, status
    `;
    
    return siswa!;
  }
);
